/*
Dane wejsciowe (wlasnosci werteksu):
gl_Vertex - pooenie (we wsp. modelu), vec4
gl_Color - kolor, vec4
gl_Normal - normalna, vec3
gl_MultiTexCoord0 - wsprzdne teksturowania (indeks 0), vec4

Parametry:
gl_ModelViewProjectionMatrix = mul(gl_ProjectionMatrix,gl_ModelViewMatrix), mat4
gl_NormalMatrix, mat3 (transponowane elementy z gl_ModelViewMatrix przyciete do mat3)

Dane wyjsciowe (wlasnosci werteksu):
gl_Position - pozycja (obowizkowe!), vec4
gl_FrontColor - kolor, vec4
*/

varying vec4 pozycja;
varying vec3 normalna;
varying vec2 wspTeksturowania;

void main(void)
{
    // przeksztacenia model-widok
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;   

    pozycja=gl_ModelViewMatrix*gl_Vertex;
    normalna=gl_NormalMatrix*gl_Normal;
    wspTeksturowania=(gl_TextureMatrix[0]*gl_MultiTexCoord0).st;

    //model Phonga
    gl_FrontColor = gl_Color;
}
